$(document).ready(function ($) {

    // default updated iframe dimensions
    var dimensions;

    /**
     * Handles the postMessage functionality
     *
     * @method recieve_message
     * @param {Object} event The postMessage request object
     */
    receive_message = function (event) {

        // ignore messages that are not from a valid source
        if (event.origin != origin) { return; }

        // message is to close fancybox
        if (event.data == 'action:cancel') {

            // close/remove fancybox
            $.fancybox.close();

        } else {

            // message contains 'size' keyword
            if (event.data.indexOf('size:') > -1) {

                // translate 'size' method into new iframe dimensions
                var size = event.data.replace('size:', '');
                var iframe_dimensions = size.split('x');

                // set updated iframe dimensions
                dimensions = {};
                dimensions.width  = parseInt(iframe_dimensions[0])+20;
                dimensions.height = parseInt(iframe_dimensions[1])+20;
            }
        }
    };

    // add event listener for postMessage
    window.addEventListener("message", receive_message, false);

    /**
     * Gets the dimensions to use for the desired form with fancybox.
     * It detects for CSS overrides first, then it falls back to the
     * given defaults based on window width
     *
     * @method get_form_dimensions
     * @param {String} override_css_class The name of the overriding CSS class
     * @param {String} defaults_css_class The name of the defaults CSS class
     * @return {Object} The dimensions to be used by the fancybox call
     */
    get_form_dimensions = function (override_css_class, defaults_css_class) {

        // set up the return object
        var iframe_dimensions = {};

        // get the width and height of the override class associated with the fancybox container
        var css_width  = $('div.'+override_css_class).css('width');
        var css_height = $('div.'+override_css_class).css('height');

        // width and height for the fancybox container is defined in the CSS via the override class
        if (css_width != '0px' && css_height != '0px') {

            // remove the override class from the fancybox container
            $('div.'+override_css_class).removeClass(override_css_class);

            // set the override dimensions to the return object
            iframe_dimensions.width  = css_width;
            iframe_dimensions.height = css_height;

        } else {

            // remove the override class and add the defaults class to the fancybox container
            $('div.'+override_css_class).removeClass(override_css_class).addClass(defaults_css_class);

            // set the override dimensions to the return object
            iframe_dimensions.width  = $('div.'+defaults_css_class).css('width');
            iframe_dimensions.height = $('div.'+defaults_css_class).css('height');

            // remove the override class from the fancybox container
            $('div.'+defaults_css_class).removeClass(defaults_css_class);
        }

        // return set dimensions
        return iframe_dimensions;
    };

    /**
     * Executes the call to the fancybox plugin with clean options 
     * along with the desired form information
     *
     * @method execute_fancybox
     * @param {String} form_url The URL of the desired form
     * @param {String} override_css_class The name of the overriding CSS class
     * @param {String} defaults_css_class The name of the defaults CSS class
     */
    execute_fancybox = function (form_url, override_css_class, defaults_css_class) {
        
        // setup fancybox with clean options and desired form information
        $.fancybox({
            autoSize: false,
            autoResize: false,
            wrapCSS: override_css_class,
            openEffect: 'none',
            closeEffect: 'none',
            type: 'iframe',
            href: form_url+'&referer='+referer,
            afterLoad: function () {

                // get fancybox dimensions
                var iframe_dimensions = get_form_dimensions(override_css_class, defaults_css_class);

                // set fancybox dimensions
                this.width    = iframe_dimensions.width;
                this.maxWidth = iframe_dimensions.width;

                this.height    = iframe_dimensions.height;
                this.maxHeight = iframe_dimensions.height;
            },
            onUpdate: function () {

                // updated iframe dimensions are defined
                if (dimensions != undefined) {

                    // update iframe dimensions
                    this.width    = dimensions.width;
                    this.maxWidth = dimensions.width;

                    this.height    = dimensions.height;
                    this.maxHeight = dimensions.height;

                    // animate updates
                    $('div.fancybox-inner').animate({height: dimensions.height}, 1000);

                    // reset updated iframe dimensions
                    dimensions = undefined;
                }
            }
        });

        // set up fancybox to update/resize and reposition to the center when the current window resizes
        $(window).resize(function () {
            $.fancybox.update();
            $.fancybox.reposition();
        });
    };

    /**
     * Return the querystring part of a URL, with the GET params from the current window
     * Used to forward the GET params that generates the skin selector to the fancybox in order to be styled
     *
     * @return {String} querystring part of a URL
     */
    get_url_params = function () {
        
        skin_params = "";
        if(window.location.search.indexOf('?') == 0) {
            skin_params = '&'+window.location.search.substr(1);
        }

        return skin_params;
    };

    /**
     * Overloads the standard window.onmessage method to 
     * receive the height and apply it to the fancybox wrap
     *
     * @method window.onmessage
     * @param {object} the event
     */
    window.onmessage = function(event) {

        if ($.type(event.data) === "string") {

            // make data passed in into a usable integer
            var res = parseInt(event.data.replace("'", ""));

            // data is numeric
            if ($.isNumeric(res)) {

                // update the fancybox wrap with the new height
                $('.fancybox-inner').css('maxHeight', (res*1)+'px');
            }
        }
    };

    // unbind any previous 'click' methods
    $('.send_friend, .email_us, .launch_email_us, .request_appointment, .fancybox-appointment-iframe, .fancybox-emailus-iframe, .email-doctor, li[onclick*="request_appointment=1"], li[onclick*="send_doctor=1"], li[onclick*="send_email=1"], img[data-link*="request_appointment=1"], img[data-link*="send_doctor=1"], img[data-link*="send_email=1"]').each(function(){
        $(this).off('click');
    });

    // remove any defined 'onclick' attributes
    $('.send_friend, .email_us, .launch_email_us, .request_appointment, .fancybox-appointment-iframe, .fancybox-emailus-iframe, .email-doctor, img[data-link*="request_appointment=1"], img[data-link*="send_doctor=1"], img[data-link*="send_email=1"]').each(function(){

        // get attribute value
        var onclick = $(this).attr('onclick');

        // actually contains value
        if (typeof onclick != undefined && onclick !== false) {

            // remove onclick attribute
            $(this).removeAttr('onclick');
            $(this).prop('onclick', null);
        }
    });

    // email us - bind the desired code to the 'click' method
    $('.launch_email_us, .email_us, .fancybox-emailus-iframe, .email-doctor, img[data-link*="send_doctor=1"]').on('click', function(event) {

        // disable default behavior
        (event.preventDefault) ? event.preventDefault() : event.returnValue = false;

        skin_params = get_url_params();

        // call method that executes clean fancybox code
        execute_fancybox(sdomain+'/?send_doctor=1'+skin_params, 'fancybox-secure-form-email-us', 'fancybox-secure-form-defaults-email-us');
    });

    // email us - bind the desired code to the 'click' method
    $('li[onclick*="send_doctor=1"]').on('click', function(event) {

        // disable default behavior
        (event.preventDefault) ? event.preventDefault() : event.returnValue = false;

        // remove onclick attribute
        $(this).removeAttr('onclick');
        $(this).prop('onclick', null);

        skin_params = get_url_params();

        // call method that executes clean fancybox code
        execute_fancybox(sdomain+'/?send_doctor=1'+skin_params, 'fancybox-secure-form-email-us', 'fancybox-secure-form-defaults-email-us');
    });

    // send to friend - bind the desired code to the 'click' method
    $('.send_friend, img[data-link*="send_email=1"]').on('click', function(event) {

        // disable default behavior
        (event.preventDefault) ? event.preventDefault() : event.returnValue = false;

        skin_params = get_url_params();

        url = window.location.href.split('?')[0];

        title_candidate = (document.title.indexOf('::') != -1) ? document.title.split('::')[1].trim() : document.title;

        // call method that executes clean fancybox code
        execute_fancybox(url+'?send_email=1&title='+title_candidate+skin_params, 'fancybox-secure-form-send-to-friend', 'fancybox-secure-form-defaults-send-to-friend');
    });

    // send to friend - bind the desired code to the 'click' method
    $('li[onclick*="send_email=1"]').on('click', function(event) {

        // disable default behavior
        (event.preventDefault) ? event.preventDefault() : event.returnValue = false;

        skin_params = get_url_params();

        // remove onclick attribute
        $(this).removeAttr('onclick');
        $(this).prop('onclick', null);

        // call method that executes clean fancybox code
        execute_fancybox(sdomain+'/?send_email=1&title='+skin_params, 'fancybox-secure-form-send-to-friend', 'fancybox-secure-form-defaults-send-to-friend');
    });

    // request appointment - bind the desired code to the 'click' method
    $('.request_appointment, .fancybox-appointment-iframe, img[data-link*="request_appointment=1"]').on('click', function(event) {

        // disable default behavior
        (event.preventDefault) ? event.preventDefault() : event.returnValue = false;

        skin_params = get_url_params();

        // call method that executes clean fancybox code
        execute_fancybox(sdomain+'/?request_appointment=1'+skin_params, 'fancybox-secure-form-request-appointment', 'fancybox-secure-form-defaults-request-appointment');
    });

    // request appointment - bind the desired code to the 'click' method
    $('li[onclick*="request_appointment=1"]').on('click', function(event) {

        // disable default behavior
        (event.preventDefault) ? event.preventDefault() : event.returnValue = false;

        // remove onclick attribute
        $(this).removeAttr('onclick');
        $(this).prop('onclick', null);

        skin_params = get_url_params();

        // call method that executes clean fancybox code
        execute_fancybox(sdomain+'/?request_appointment=1'+skin_params, 'fancybox-secure-form-request-appointment', 'fancybox-secure-form-defaults-request-appointment');
    });

    // handle slider functionality anytime a new slide is loaded - attach to the button text
    $('.button_text').on('DOMNodeInserted', function(event){

        // the button text contains an anchor tag
        if ($(this).children('a').length > 0) {

            // get child (anchor tag) object
            var child = $(this).children('a');

            // child (anchor tag) object has an 'href' attribute
            if ($(child).attr('href').length > 0) {

                // get the value of the 'href' attribute
                var link = $(child).attr('href');

                // default fancybox config object
                var fb_info = {};

                // the value of 'href' is a 'request appointment' URL
                if (link.indexOf('request_appointment=1') > -1) {

                    // set fancybox config info
                    fb_info = {
                        link: sdomain+'/?request_appointment=1',
                        o_css: 'fancybox-secure-form-request-appointment',
                        d_css: 'fancybox-secure-form-defaults-request-appointment'
                    };
                }

                // the value of 'href' is a 'send to doctor' URL
                if (link.indexOf('send_doctor=1') > -1) {

                    // set fancybox config info
                    fb_info = {
                        link: sdomain+'/?send_doctor=1',
                        o_css: 'fancybox-secure-form-email-us',
                        d_css: 'fancybox-secure-form-defaults-email-us'
                    };
                }

                // the value of 'href' is a 'send to friend' URL
                if (link.indexOf('send_email=1') > -1) {

                    // set fancybox config info
                    fb_info = {
                        link: sdomain+'/?send_email=1&title=',
                        o_css: 'fancybox-secure-form-send-to-friend',
                        d_css: 'fancybox-secure-form-defaults-send-to-friend'
                    };
                }

                // fancybox config is populated (this is a form link)
                if (!$.isEmptyObject(fb_info)) {

                    // remove the 'href' attribute of the child (anchor tag) object
                    $(child).removeAttr('href');

                    // bind the desired code to the 'click' event of the child (anchor tag) object
                    $(child).on('click', function(event) {

                        // disable default behavior
                        (event.preventDefault) ? event.preventDefault() : event.returnValue = false;

                        // call method that executes clean fancybox code
                        execute_fancybox(fb_info.link, fb_info.o_css, fb_info.d_css);
                    });
                }
            }
        }
    });
});