"use strict";function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true});}else{obj[key]=value;}return obj;}
class ImageResizer{static resize(file,options,callback){this._init();var thisOptions={maxWidth:1200};$.extend(thisOptions,options);var width=thisOptions.maxWidth;var fileName=file.name;var fileType=file.type;const reader=new FileReader();reader.readAsDataURL(file);reader.onload=function(event){const img=new Image();img.src=event.target.result;img.onload=function(){if(width>img.width){width=img.width;}
const elem=document.createElement('canvas');elem.width=width;const scaleFactor=width/img.width;elem.height=img.height*scaleFactor;const ctx=elem.getContext('2d');ctx.drawImage(img,0,0,width,img.height*scaleFactor);ctx.canvas.toBlob(function(blob){blob.lastModifiedDate=Date.now();blob.name=fileName;blob.width=width;blob.height=img.height*scaleFactor;callback(undefined,blob);},fileType,1);},reader.onerror=function(error){callback(error);};};}
static _init(){if(!this._initDone){this._initDone=true;if(!HTMLCanvasElement.prototype.toBlob){Object.defineProperty(HTMLCanvasElement.prototype,'toBlob',{value:function(callback,type,quality){var dataURL=this.toDataURL(type,quality).split(',')[1];setTimeout(function(){var binStr=atob(dataURL),len=binStr.length,arr=new Uint8Array(len);for(var i=0;i<len;i++){arr[i]=binStr.charCodeAt(i);}
callback(new Blob([arr],{type:type||'image/png'}));});}});}}}}
_defineProperty(ImageResizer,"_initDone",false);